/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.basic;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import sonar.fluxnetworks.client.gui.EnumNavigationTab;
import sonar.fluxnetworks.client.gui.basic.GuiPopupCore;
import sonar.fluxnetworks.client.gui.basic.GuiPopupHost;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.FluxEditBox;
import sonar.fluxnetworks.common.connection.FluxMenu;

public abstract class GuiFocusable
extends AbstractContainerScreen<FluxMenu> {
    public static final int TEXTURE_SIZE = 512;
    public static final ResourceLocation BACKGROUND = new ResourceLocation("fluxnetworks", "textures/gui/gui_background.png");
    public static final ResourceLocation FRAME = new ResourceLocation("fluxnetworks", "textures/gui/gui_frame.png");
    public static final ResourceLocation ICON = new ResourceLocation("fluxnetworks", "textures/gui/gui_icon.png");

    public GuiFocusable(FluxMenu menu, @Nonnull Player player) {
        super((AbstractContainerMenu)menu, player.m_150109_(), TextComponent.f_131282_);
    }

    public void m_7522_(@Nullable GuiEventListener listener) {
        super.m_7522_(listener);
        for (GuiEventListener child : this.m_6702_()) {
            FluxEditBox editBox;
            if (child == listener || !(child instanceof FluxEditBox) || !(editBox = (FluxEditBox)child).m_93696_()) continue;
            editBox.m_93692_(false);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.m_7222_() != null) {
            if (keyCode == 256) {
                this.m_7522_(null);
                return true;
            }
            if (this.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(key)) {
                return false;
            }
        } else if (keyCode == 256 || this.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(key)) {
            GuiFocusable guiFocusable = this;
            if (guiFocusable instanceof GuiPopupCore) {
                GuiPopupCore core = (GuiPopupCore)guiFocusable;
                ((GuiPopupHost)((Object)core.mHost)).closePopup();
                return true;
            }
            guiFocusable = this;
            if (guiFocusable instanceof GuiTabCore) {
                GuiTabCore core = (GuiTabCore)guiFocusable;
                if (core.getNavigationTab() == EnumNavigationTab.TAB_HOME) {
                    this.m_7379_();
                } else {
                    core.switchTab(EnumNavigationTab.TAB_HOME, true);
                }
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_181908_() {
        super.m_181908_();
        for (GuiEventListener child : this.m_6702_()) {
            if (!(child instanceof FluxEditBox)) continue;
            FluxEditBox editBox = (FluxEditBox)child;
            editBox.m_94120_();
        }
    }

    protected void blitBackgroundOrFrame(@Nonnull PoseStack poseStack) {
        float cx = (float)this.f_96543_ / 2.0f;
        float cy = (float)this.f_96544_ / 2.0f + 5.0f;
        GuiFocusable.blitF(poseStack.m_85850_().m_85861_(), cx - 86.0f, cy - 86.0f, this.m_93252_(), 172.0f, 172.0f, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public void blitF(@Nonnull PoseStack poseStack, float x, float y, float width, float height, float uOffset, float vOffset, float uWidth, float vHeight) {
        float minU = uOffset / 512.0f;
        float minV = vOffset / 512.0f;
        float maxU = (uOffset + uWidth) / 512.0f;
        float maxV = (vOffset + vHeight) / 512.0f;
        GuiFocusable.blitF(poseStack.m_85850_().m_85861_(), x, y, this.m_93252_(), width, height, minU, minV, maxU, maxV);
    }

    public static void blitF(Matrix4f matrix, float x, float y, float z, float width, float height, float minU, float minV, float maxU, float maxV) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        builder.m_85982_(matrix, x + width, y, z).m_7421_(maxU, minV).m_5752_();
        builder.m_85982_(matrix, x, y, z).m_7421_(minU, minV).m_5752_();
        builder.m_85982_(matrix, x, y + height, z).m_7421_(minU, maxV).m_5752_();
        builder.m_85982_(matrix, x + width, y + height, z).m_7421_(maxU, maxV).m_5752_();
        builder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)builder);
    }
}

